/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.ConditionalMana;
import mage.MageObject;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.conditional.ManaCondition;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TazriStalwartSurvivorManaEffect
extends ManaEffect {
    public TazriStalwartSurvivorManaEffect() {
        this.staticText = "Add one mana of any of this creature's colors. Spend this mana only to activate an ability of a creature";
    }

    private TazriStalwartSurvivorManaEffect(TazriStalwartSurvivorManaEffect effect) {
        super((ManaEffect)effect);
    }

    public TazriStalwartSurvivorManaEffect copy() {
        return new TazriStalwartSurvivorManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game == null) {
            return new ArrayList<Mana>();
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return new ArrayList<Mana>();
        }
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        ObjectColor color = permanent.getColor(game);
        if (color.isWhite()) {
            netMana.add((Mana)new TazriStalwartSurvivorConditionalMana(Mana.WhiteMana((int)1)));
        }
        if (color.isBlue()) {
            netMana.add((Mana)new TazriStalwartSurvivorConditionalMana(Mana.BlueMana((int)1)));
        }
        if (color.isBlack()) {
            netMana.add((Mana)new TazriStalwartSurvivorConditionalMana(Mana.BlackMana((int)1)));
        }
        if (color.isRed()) {
            netMana.add((Mana)new TazriStalwartSurvivorConditionalMana(Mana.RedMana((int)1)));
        }
        if (color.isGreen()) {
            netMana.add((Mana)new TazriStalwartSurvivorConditionalMana(Mana.GreenMana((int)1)));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return new Mana();
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || permanent == null) {
            return new Mana();
        }
        ChoiceImpl choice = new ChoiceImpl(false).setManaColorChoice(true);
        choice.setMessage("Pick a mana color");
        ObjectColor color = permanent.getColor(game);
        if (color.isWhite()) {
            choice.getChoices().add("White");
        }
        if (color.isBlue()) {
            choice.getChoices().add("Blue");
        }
        if (color.isBlack()) {
            choice.getChoices().add("Black");
        }
        if (color.isRed()) {
            choice.getChoices().add("Red");
        }
        if (color.isGreen()) {
            choice.getChoices().add("Green");
        }
        if (choice.getChoices().isEmpty()) {
            return new Mana();
        }
        if (choice.getChoices().size() == 1) {
            choice.setChoice((String)choice.getChoices().iterator().next());
        } else {
            controller.choose(Outcome.PutManaInPool, (Choice)choice, game);
        }
        if (choice.getChoice() == null) {
            return new Mana();
        }
        switch (choice.getChoice()) {
            case "White": {
                return new TazriStalwartSurvivorConditionalMana(Mana.WhiteMana((int)1));
            }
            case "Blue": {
                return new TazriStalwartSurvivorConditionalMana(Mana.BlueMana((int)1));
            }
            case "Black": {
                return new TazriStalwartSurvivorConditionalMana(Mana.BlackMana((int)1));
            }
            case "Red": {
                return new TazriStalwartSurvivorConditionalMana(Mana.RedMana((int)1));
            }
            case "Green": {
                return new TazriStalwartSurvivorConditionalMana(Mana.GreenMana((int)1));
            }
        }
        return new Mana();
    }

    private static final class TazriStalwartSurvivorManaCondition
    extends ManaCondition
    implements Condition {
        private TazriStalwartSurvivorManaCondition() {
        }

        public boolean apply(Game game, Ability source) {
            if (!source.isActivatedAbility()) {
                return false;
            }
            MageObject object = game.getObject(source);
            return object != null && object.isCreature(game) && !source.isActivated();
        }

        public boolean apply(Game game, Ability source, UUID originalId, Cost costsToPay) {
            return this.apply(game, source);
        }
    }

    private static final class TazriStalwartSurvivorConditionalMana
    extends ConditionalMana {
        public TazriStalwartSurvivorConditionalMana(Mana mana) {
            super(mana);
            this.staticText = "Spend this mana only to activate abilities of creatures";
            this.addCondition(new TazriStalwartSurvivorManaCondition());
        }
    }
}

