/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TazriStalwartSurvivorMillEffect
extends OneShotEffect {
    TazriStalwartSurvivorMillEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill five cards. Put all creature cards with activated abilities that aren't mana abilities from among the milled cards into your hand";
    }

    private TazriStalwartSurvivorMillEffect(TazriStalwartSurvivorMillEffect effect) {
        super((OneShotEffect)effect);
    }

    public TazriStalwartSurvivorMillEffect copy() {
        return new TazriStalwartSurvivorMillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(5, source, game);
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        cards.removeIf(uuid -> game.getCard(uuid).getAbilities(game).stream().noneMatch(Ability::isNonManaActivatedAbility));
        player.moveCards(cards, Zone.HAND, source, game);
        return true;
    }
}

