/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TeleportalEffect
extends OneShotEffect {
    TeleportalEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "each creature you control can't be blocked this turn";
    }

    private TeleportalEffect(TeleportalEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, source.getControllerId(), source, game)) {
            CantBeBlockedTargetEffect effect = new CantBeBlockedTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    public TeleportalEffect copy() {
        return new TeleportalEffect(this);
    }
}

