/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TempOfTheDamnedUpkeepEffect
extends OneShotEffect {
    TempOfTheDamnedUpkeepEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "remove a funk counter from {this}. If you can't, sacrifice it";
    }

    private TempOfTheDamnedUpkeepEffect(TempOfTheDamnedUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            int amount = permanent.getCounters(game).getCount(CounterType.FUNK);
            if (amount > 0) {
                permanent.removeCounters(CounterType.FUNK.createInstance(), source, game);
            } else {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    public TempOfTheDamnedUpkeepEffect copy() {
        return new TempOfTheDamnedUpkeepEffect(this);
    }
}

