/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class TempleOfPowerWatcher
extends Watcher {
    private final Map<UUID, Integer> damageMap = new HashMap<UUID, Integer>();

    public TempleOfPowerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT) {
            Permanent sourceObject;
            DamagedEvent dmgEvent = (DamagedEvent)event;
            if (dmgEvent == null || dmgEvent.isCombatDamage()) {
                return;
            }
            UUID sourceControllerId = null;
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            if (sourcePermanent != null) {
                sourceObject = sourcePermanent;
                sourceControllerId = sourcePermanent.getControllerId();
            } else {
                sourceObject = game.getSpellOrLKIStack(event.getSourceId());
                if (sourceObject != null) {
                    sourceControllerId = ((StackObject)sourceObject).getControllerId();
                } else {
                    sourceObject = game.getObject(event.getSourceId());
                    if (sourceObject instanceof CommandObject) {
                        sourceControllerId = ((CommandObject)sourceObject).getControllerId();
                    }
                }
            }
            if (sourceObject == null || sourceControllerId == null || !sourceObject.getColor().isRed()) {
                return;
            }
            this.damageMap.compute(sourceControllerId, (k, i) -> (i == null ? 0 : i) + event.getAmount());
        }
    }

    public void reset() {
        this.damageMap.clear();
        super.reset();
    }

    int damageForPlayer(UUID playerId) {
        return this.damageMap.getOrDefault(playerId, 0);
    }
}

