/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.t.TemporalApertureTopCardCastEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TemporalApertureEffect
extends OneShotEffect {
    TemporalApertureEffect() {
        super(Outcome.Neutral);
        this.staticText = "Shuffle your library, then reveal the top card. Until end of turn, for as long as that card remains on top of your library, play with the top card of your library revealed and you may play that card without paying its mana cost";
    }

    private TemporalApertureEffect(TemporalApertureEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.shuffleLibrary(source, game);
            Card topCard = controller.getLibrary().getFromTop(game);
            if (topCard != null) {
                CardsImpl cards = new CardsImpl(topCard);
                controller.revealCards("Top card of " + controller.getName() + "'s library revealed", (Cards)cards, game);
                TemporalApertureTopCardCastEffect effect = new TemporalApertureTopCardCastEffect(topCard);
                game.addEffect((ContinuousEffect)effect, source);
                return true;
            }
        }
        return false;
    }

    public TemporalApertureEffect copy() {
        return new TemporalApertureEffect(this);
    }
}

