/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class TemptWithMayhemEffect
extends OneShotEffect {
    TemptWithMayhemEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target instant or sorcery spell. Each opponent may copy that spell and may choose new targets for the copy they control. You copy that spell once plus an additional time for each opponent who copied the spell this way. You may choose new targets for the copies you control";
    }

    private TemptWithMayhemEffect(TemptWithMayhemEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithMayhemEffect copy() {
        return new TemptWithMayhemEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        int count = 0;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.chooseUse(Outcome.Copy, "Copy " + spell.getIdName() + '?', source, game)) continue;
            spell.createCopyOnStack(game, source, opponentId, true);
            ++count;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), true, count + 1);
        return true;
    }
}

