/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class TemptingContractEffect
extends OneShotEffect {
    TemptingContractEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may create a Treasure token. For each opponent who does, you create a Treasure token";
    }

    private TemptingContractEffect(TemptingContractEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptingContractEffect copy() {
        return new TemptingContractEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int counter = 0;
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || !opponent.chooseUse(this.outcome, "Create a Treasure token?", "If you do, " + controller.getName() + " will create one as well", "Yes", "No", source, game) || !new TreasureToken().putOntoBattlefield(1, game, source, opponent.getId())) continue;
            ++counter;
        }
        if (counter > 0) {
            new TreasureToken().putOntoBattlefield(counter, game, source, source.getControllerId());
            return true;
        }
        return false;
    }
}

