/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TemurSabertoothEffect
extends OneShotEffect {
    TemurSabertoothEffect() {
        super(Outcome.Detriment);
        this.staticText = "You may return another creature you control to its owner's hand. If you do, {this} gains indestructible until end of turn";
    }

    private TemurSabertoothEffect(TemurSabertoothEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemurSabertoothEffect copy() {
        return new TemurSabertoothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL, true);
            if (target.canChoose(controller.getId(), source, game) && controller.chooseUse(this.outcome, "Return another creature to hand?", source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                Permanent toHand = game.getPermanent(target.getFirstTarget());
                if (toHand != null) {
                    controller.moveCards((Card)toHand, Zone.HAND, source, game);
                }
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

