/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.t.TergridGodOfFrightEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TergridGodOfFrightTriggeredAbility
extends TriggeredAbilityImpl {
    private static final String RULE_TEXT = "Whenever an opponent sacrifices a nontoken permanent or discards a permanent card, you may put that card from a graveyard onto the battlefield under your control";

    public TergridGodOfFrightTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TergridGodOfFrightEffect(), true);
    }

    private TergridGodOfFrightTriggeredAbility(TergridGodOfFrightTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TergridGodOfFrightTriggeredAbility copy() {
        return new TergridGodOfFrightTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICED_PERMANENT || event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case SACRIFICED_PERMANENT: {
                Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
                if (permanent != null && !(permanent instanceof PermanentToken) && game.getState().getZone(permanent.getId()) == Zone.GRAVEYARD) break;
                return false;
            }
            case DISCARDED_CARD: {
                Card discardedCard = game.getCard(event.getTargetId());
                if (discardedCard != null && discardedCard.isPermanent(game) && game.getState().getZone(discardedCard.getId()) == Zone.GRAVEYARD) break;
                return false;
            }
            default: {
                return false;
            }
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }

    public String getRule() {
        return "Whenever an opponent sacrifices a nontoken permanent or discards a permanent card, you may put that card from a graveyard onto the battlefield under your control.";
    }
}

