/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TerraformerContinuousEffect;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TerraformerEffect
extends OneShotEffect {
    TerraformerEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose a basic land type. Each land you control becomes that type until end of turn";
    }

    private TerraformerEffect(TerraformerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerraformerEffect copy() {
        return new TerraformerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            ChoiceBasicLandType choice = new ChoiceBasicLandType();
            if (player.choose(Outcome.Neutral, (Choice)choice, game)) {
                game.getState().setValue(source.getSourceId().toString() + "_Terraformer", (Object)choice.getChoice());
            }
            game.addEffect((ContinuousEffect)new TerraformerContinuousEffect(), source);
            return true;
        }
        return false;
    }
}

