/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.token.LanderToken;
import mage.players.Player;

class TerrapactIntimidatorEffect
extends OneShotEffect {
    TerrapactIntimidatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent may have you create two Lander tokens. If they don't, put two +1/+1 counters on this creature";
    }

    private TerrapactIntimidatorEffect(TerrapactIntimidatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerrapactIntimidatorEffect copy() {
        return new TerrapactIntimidatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (player.chooseUse(Outcome.Detriment, "Have " + Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getLogName).orElse("them") + " create two Lander tokens?", source, game)) {
            return new LanderToken().putOntoBattlefield(2, game, source);
        }
        return Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).filter(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(2), source, game)).isPresent();
    }
}

