/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TersaLightshatterEffect
extends OneShotEffect {
    TersaLightshatterEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a card at random from your graveyard. You may play that card this turn";
    }

    private TersaLightshatterEffect(TersaLightshatterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TersaLightshatterEffect copy() {
        return new TersaLightshatterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getGraveyard().getRandom(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        return true;
    }
}

