/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class TeveshSzatDoomOfFoolsSacrificeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("another creature or planeswalker you control");

    TeveshSzatDoomOfFoolsSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature or planeswalker. If you do, draw two cards, then draw another card if the sacrificed permanent was a commander";
    }

    private TeveshSzatDoomOfFoolsSacrificeEffect(TeveshSzatDoomOfFoolsSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeveshSzatDoomOfFoolsSacrificeEffect copy() {
        return new TeveshSzatDoomOfFoolsSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean isCommander;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        target.choose(this.outcome, source.getControllerId(), source.getSourceId(), source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player permanentController = game.getPlayer(permanent.getControllerId());
        boolean bl = isCommander = permanentController != null && game.getCommandersIds(permanentController, CommanderCardType.COMMANDER_OR_OATHBREAKER, true).contains(permanent.getId());
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        controller.drawCards(2, source, game);
        if (isCommander) {
            controller.drawCards(1, source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

