/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.cards.t.TezzeretCruelMachinistCardTypeEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TezzeretCruelMachinistEffect
extends OneShotEffect {
    TezzeretCruelMachinistEffect() {
        super(Outcome.Benefit);
        this.staticText = "put any number of cards from your hand onto the battlefield face down. They're 5/5 artifact creatures";
    }

    private TezzeretCruelMachinistEffect(TezzeretCruelMachinistEffect effect) {
        super((OneShotEffect)effect);
    }

    public TezzeretCruelMachinistEffect copy() {
        return new TezzeretCruelMachinistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, StaticFilters.FILTER_CARD);
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cardsToMove = new CardsImpl((Collection)target.getTargets());
        if (cardsToMove.isEmpty()) {
            return false;
        }
        game.addEffect(new TezzeretCruelMachinistCardTypeEffect().setTargetPointer((TargetPointer)new FixedTargets((Collection)cardsToMove.getCards(game).stream().map(card -> new MageObjectReference((MageObject)card, game, 1)).collect(Collectors.toList()))), source);
        player.moveCards(cardsToMove.getCards(game), Zone.BATTLEFIELD, source, game, false, true, true, null);
        return true;
    }
}

