/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TezzeretMasterOfTheBridgeEffect2
extends OneShotEffect {
    TezzeretMasterOfTheBridgeEffect2() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top ten cards of your library. Put all artifact cards from among them onto the battlefield.";
    }

    private TezzeretMasterOfTheBridgeEffect2(TezzeretMasterOfTheBridgeEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public TezzeretMasterOfTheBridgeEffect2 copy() {
        return new TezzeretMasterOfTheBridgeEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 10));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        CardsImpl cards2 = new CardsImpl();
        for (Card card : cards.getCards(game)) {
            if (!card.isArtifact(game)) continue;
            cards2.add(card);
        }
        return player.moveCards((Cards)cards2, Zone.BATTLEFIELD, source, game);
    }
}

