/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TheAesirEscapeValhallaThreeEffect
extends OneShotEffect {
    TheAesirEscapeValhallaThreeEffect() {
        super(Outcome.Neutral);
        this.staticText = "Return {this} and the exiled card to their owner's hand.";
    }

    private TheAesirEscapeValhallaThreeEffect(TheAesirEscapeValhallaThreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAesirEscapeValhallaThreeEffect copy() {
        return new TheAesirEscapeValhallaThreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        if (sourcePermanent != null) {
            exileZone.add((Card)sourcePermanent);
        }
        controller.moveCards((Cards)exileZone, Zone.HAND, source, game);
        return true;
    }
}

