/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.IncubateEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheArgentEtchingsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.INCUBATOR);

    TheArgentEtchingsEffect() {
        super(Outcome.Benefit);
        this.staticText = "incubate 2 five times, then transform all Incubator tokens you control";
    }

    private TheArgentEtchingsEffect(TheArgentEtchingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheArgentEtchingsEffect copy() {
        return new TheArgentEtchingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (int i = 0; i < 5; ++i) {
            IncubateEffect.doIncubate((int)2, (Game)game, (Ability)source);
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.transform(source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

