/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;
import mage.target.Target;

class TheBindingOfTheTitansEffect
extends OneShotEffect {
    TheBindingOfTheTitansEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile up to two target cards from graveyards. For each creature card exiled this way, you gain 1 life.";
    }

    private TheBindingOfTheTitansEffect(TheBindingOfTheTitansEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBindingOfTheTitansEffect copy() {
        return new TheBindingOfTheTitansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toList()));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        int lifeToGain = cards.getCards(game).stream().filter(card -> card.isCreature(game)).map(MageItem::getId).map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).map(arg_0 -> Zone.EXILED.equals(arg_0)).mapToInt(b -> b != false ? 1 : 0).sum();
        return player.gainLife(lifeToGain, game, source) > 0;
    }
}

