/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.VecnaToken;

class TheBookOfVileDarknessEffect
extends OneShotEffect {
    TheBookOfVileDarknessEffect() {
        super(Outcome.Benefit);
        this.staticText = "create Vecna, a legendary 8/8 black Zombie God creature token with indestructible and all triggered abilities of the exiled cards";
    }

    private TheBookOfVileDarknessEffect(TheBookOfVileDarknessEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBookOfVileDarknessEffect copy() {
        return new TheBookOfVileDarknessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set morSet = (Set)this.getValue("BookEyeHand");
        if (morSet == null) {
            return false;
        }
        VecnaToken token = new VecnaToken();
        for (MageObjectReference mor : morSet) {
            Permanent card = mor.getPermanentOrLKIBattlefield(game);
            if (card == null) continue;
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isTriggeredAbility()) continue;
                Ability copyAbility = ability.copy();
                copyAbility.newId();
                copyAbility.setControllerId(source.getControllerId());
                token.addAbility(copyAbility, true);
            }
        }
        return token.putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

