/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TheBrothersWarRequirementEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheBrothersWarEffect
extends OneShotEffect {
    TheBrothersWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose two target players. Until your next turn, each creature they control attacks the other chosen player each combat if able";
    }

    private TheBrothersWarEffect(TheBrothersWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBrothersWarEffect copy() {
        return new TheBrothersWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List players = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (players.size() != 2) {
            return false;
        }
        game.addEffect((ContinuousEffect)new TheBrothersWarRequirementEffect((Player)players.get(0), (Player)players.get(1)), source);
        game.addEffect((ContinuousEffect)new TheBrothersWarRequirementEffect((Player)players.get(1), (Player)players.get(0)), source);
        return true;
    }
}

