/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheCelestusLootEffect
extends OneShotEffect {
    TheCelestusLootEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you gain 1 life. You may draw a card. If you do, discard a card";
    }

    private TheCelestusLootEffect(TheCelestusLootEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCelestusLootEffect copy() {
        return new TheCelestusLootEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.gainLife(1, game, source);
        if (player.chooseUse(this.outcome, "Draw a card?", source, game)) {
            player.drawCards(1, source, game);
            player.discard(1, false, false, source, game);
        }
        return true;
    }
}

