/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseGameTargetPlayerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheDeckOfManyThingsDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    TheDeckOfManyThingsDelayedTriggeredAbility(Permanent permanent, Game game) {
        super((Effect)new LoseGameTargetPlayerEffect(), Duration.Custom, false, false);
        this.mor = new MageObjectReference((MageObject)permanent, game);
    }

    private TheDeckOfManyThingsDelayedTriggeredAbility(TheDeckOfManyThingsDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || !this.mor.refersTo((MageObject)zEvent.getTarget(), game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(zEvent.getTarget().getOwnerId(), game));
        return true;
    }

    public TheDeckOfManyThingsDelayedTriggeredAbility copy() {
        return new TheDeckOfManyThingsDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When that creature dies, its owner loses the game.";
    }
}

