/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetPermanent;

class TheFallOfKroogTarget
extends TargetPermanent {
    TheFallOfKroogTarget() {
        super(1, 1, (FilterPermanent)StaticFilters.FILTER_LAND, false);
    }

    private TheFallOfKroogTarget(TheFallOfKroogTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Player player = game.getPlayer(source.getFirstTarget());
        Permanent permanent = game.getPermanent(id);
        return player != null && permanent != null && permanent.isControlledBy(player.getId()) && super.canTarget(id, source, game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Player player = Optional.ofNullable(game.getObject(source)).filter(StackObject.class::isInstance).map(StackObject.class::cast).map(StackObject::getStackAbility).map(Ability::getFirstTarget).map(arg_0 -> ((Game)game).getPlayer(arg_0)).orElse(null);
        if (player == null) {
            return new HashSet<UUID>();
        }
        return super.possibleTargets(sourceControllerId, source, game).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isControlledBy(player.getId())).map(MageItem::getId).collect(Collectors.toSet());
    }

    public TheFallOfKroogTarget copy() {
        return new TheFallOfKroogTarget(this);
    }
}

