/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class TheFugitiveDoctorEffect
extends ContinuousEffectImpl {
    TheFugitiveDoctorEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "target instant or sorcery card in your graveyard gains flashback {2}{R}{G} until end of turn";
    }

    private TheFugitiveDoctorEffect(TheFugitiveDoctorEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheFugitiveDoctorEffect copy() {
        return new TheFugitiveDoctorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        FlashbackAbility ability = new FlashbackAbility(card, (Cost)new ManaCostsImpl("{2}{R}{G}"));
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }
}

