/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class TheGrandEvolutionEffect
extends OneShotEffect {
    TheGrandEvolutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill ten cards. Put up to two creature cards from among the milled cards onto the battlefield";
    }

    private TheGrandEvolutionEffect(TheGrandEvolutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheGrandEvolutionEffect copy() {
        return new TheGrandEvolutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(10, source, game);
        TargetCard target = new TargetCard(0, 2, Zone.ALL, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        player.choose(Outcome.PutCreatureInPlay, cards, target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }
}

