/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TheGreatWorkEffect
extends OneShotEffect {
    TheGreatWorkEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to target opponent and each creature they control";
    }

    private TheGreatWorkEffect(TheGreatWorkEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheGreatWorkEffect copy() {
        return new TheGreatWorkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        player.damage(3, source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game)) {
            permanent.damage(3, source, game);
        }
        return true;
    }
}

