/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;
import mage.watchers.common.CastFromGraveyardWatcher;

class TheGreatWorkReplacementEffect
extends ReplacementEffectImpl {
    TheGreatWorkReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "if a spell cast this way would be put into a graveyard, exile it instead";
    }

    private TheGreatWorkReplacementEffect(TheGreatWorkReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheGreatWorkReplacementEffect copy() {
        return new TheGreatWorkReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = (Card)game.getState().getValue("TheGreatWork");
        if (card != null) {
            ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (Zone.GRAVEYARD != ((ZoneChangeEvent)event).getToZone()) {
            return false;
        }
        Card card = game.getCard(event.getSourceId());
        if (card == null || !card.isInstant(game) && !card.isSorcery(game)) {
            return false;
        }
        CastFromGraveyardWatcher watcher = (CastFromGraveyardWatcher)game.getState().getWatcher(CastFromGraveyardWatcher.class);
        return watcher != null && watcher.spellWasCastFromGraveyard(event.getTargetId(), game.getState().getZoneChangeCounter(event.getTargetId()));
    }
}

