/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class TheGrimCaptainEffect
extends OneShotEffect {
    TheGrimCaptainEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may put an exiled creature card used to craft {this} onto the battlefield under your control tapped and attacking";
    }

    private TheGrimCaptainEffect(TheGrimCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheGrimCaptainEffect copy() {
        return new TheGrimCaptainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, CardUtil.getExileZoneId((Game)game, (Ability)source, (int)-2));
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.getCombat().addAttackingCreature(card.getId(), game);
        return true;
    }
}

