/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.SpawnToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;

class TheLostAndTheDamnedTriggeredAbility
extends TriggeredAbilityImpl {
    TheLostAndTheDamnedTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new SpawnToken()));
        this.setTriggerPhrase("Whenever a land you control enters from anywhere other than your hand or you cast a spell from anywhere other than your hand, ");
    }

    private TheLostAndTheDamnedTriggeredAbility(TheLostAndTheDamnedTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TheLostAndTheDamnedTriggeredAbility copy() {
        return new TheLostAndTheDamnedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                EntersTheBattlefieldEvent eEvent = (EntersTheBattlefieldEvent)event;
                return (!eEvent.getFromZone().match(Zone.HAND) || !eEvent.getTarget().isOwnedBy(this.controllerId)) && eEvent.getTarget().isLand(game);
            }
            case SPELL_CAST: {
                return !Optional.ofNullable(game.getSpell(event.getTargetId())).map(Spell::getFromZone).orElse(Zone.ALL).equals((Object)Zone.HAND) || !Optional.ofNullable(game.getSpell(event.getTargetId())).map(Spell::getOwnerId).orElse(this.controllerId).equals(this.controllerId);
            }
        }
        return false;
    }
}

