/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.UntappedBatchEvent;
import mage.game.events.UntappedEvent;
import mage.game.permanent.Permanent;

class TheMillenniumCalendarTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<UntappedEvent> {
    TheMillenniumCalendarTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private TheMillenniumCalendarTriggeredAbility(TheMillenniumCalendarTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TheMillenniumCalendarTriggeredAbility copy() {
        return new TheMillenniumCalendarTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAPPED_BATCH;
    }

    public boolean checkEvent(UntappedEvent event, Game game) {
        if (!event.isAnUntapStepEvent()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && this.isControlledBy(permanent.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.isActivePlayer(this.getControllerId())) {
            return false;
        }
        int count = this.getFilteredEvents((BatchEvent)((UntappedBatchEvent)event), game).size();
        if (count == 0) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AddCountersSourceEffect(CounterType.TIME.createInstance(count)));
        this.getHints().clear();
        this.addHint((Hint)new StaticHint("Number of untapped permanents: " + count));
        return true;
    }

    public String getRule() {
        return "Whenever you untap one or more permanents during your untap step, put that many time counters on {this}.";
    }
}

