/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.t.TheMotherlodeExcavatorCount;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.permanent.DefendingPlayerControlsSourceAttackingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;

public final class TheMotherlodeExcavator
extends CardImpl {
    private static final FilterLandPermanent filterLand = new FilterLandPermanent("nonbasic land defending player controls");
    private static final FilterCreaturePermanent filterCreatures = new FilterCreaturePermanent("creatures that player controls without flying");

    public TheMotherlodeExcavator(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{3}{R}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.ROBOT);
        this.power = new MageInt(5);
        this.toughness = new MageInt(5);
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new GetEnergyCountersControllerEffect((DynamicValue)TheMotherlodeExcavatorCount.instance).setText("choose target opponent. You get an amount of {E} <i>(energy counters)</i> equal to the number of nonbasic lands that player controls"));
        ability.addTarget((Target)new TargetOpponent());
        this.addAbility((Ability)ability);
        ReflexiveTriggeredAbility reflexiveAbility = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false);
        reflexiveAbility.addEffect(new CantBlockAllEffect(filterCreatures, Duration.EndOfTurn).concatBy(", and"));
        reflexiveAbility.addTarget((Target)new TargetPermanent((FilterPermanent)filterLand));
        this.addAbility((Ability)new AttacksTriggeredAbility((Effect)new DoWhenCostPaid(reflexiveAbility, (Cost)new PayEnergyCost(4), "Pay {E}{E}{E}{E}?")));
    }

    private TheMotherlodeExcavator(TheMotherlodeExcavator card) {
        super((CardImpl)card);
    }

    public TheMotherlodeExcavator copy() {
        return new TheMotherlodeExcavator(this);
    }

    static {
        filterLand.add((ObjectSourcePlayerPredicate)DefendingPlayerControlsSourceAttackingPredicate.instance);
        filterLand.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
        filterCreatures.add((ObjectSourcePlayerPredicate)DefendingPlayerControlsSourceAttackingPredicate.instance);
        filterCreatures.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

