/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.stack.Spell;
import mage.players.Player;

class TheMyriadPoolsCopyEffect
extends OneShotEffect {
    TheMyriadPoolsCopyEffect() {
        super(Outcome.Neutral);
        this.staticText = "up to one other target permanent you control becomes a copy of that spell until end of turn";
    }

    private TheMyriadPoolsCopyEffect(TheMyriadPoolsCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMyriadPoolsCopyEffect copy() {
        return new TheMyriadPoolsCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanentToCopyTo = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        Object spell = this.getValue("spellCast");
        if (controller == null || targetPermanentToCopyTo == null || !(spell instanceof Spell)) {
            return false;
        }
        PermanentCard newBluePrint = new PermanentCard(((Spell)spell).getCard(), source.getControllerId(), game);
        newBluePrint.assignNewId();
        CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)newBluePrint, targetPermanentToCopyTo.getId());
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, newAbility);
        return true;
    }
}

