/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheOzolithLeaveEffect
extends OneShotEffect {
    private final Counters counters;

    TheOzolithLeaveEffect(Counters counters) {
        super(Outcome.Benefit);
        this.counters = counters.copy();
    }

    private TheOzolithLeaveEffect(TheOzolithLeaveEffect effect) {
        super((OneShotEffect)effect);
        this.counters = effect.counters.copy();
    }

    public TheOzolithLeaveEffect copy() {
        return new TheOzolithLeaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        this.counters.values().forEach(counter -> permanent.addCounters(counter, source.getControllerId(), source, game));
        return true;
    }
}

