/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.common.LeavesBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.t.TheOzolithLeaveEffect;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class TheOzolithTriggeredAbility
extends LeavesBattlefieldAllTriggeredAbility {
    TheOzolithTriggeredAbility() {
        super(null, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
    }

    private TheOzolithTriggeredAbility(TheOzolithTriggeredAbility ability) {
        super((LeavesBattlefieldAllTriggeredAbility)ability);
    }

    public TheOzolithTriggeredAbility copy() {
        return new TheOzolithTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Counters counters = permanent.getCounters(game);
        if (counters.values().stream().mapToInt(Counter::getCount).noneMatch(x -> x > 0)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new TheOzolithLeaveEffect(counters));
        return true;
    }

    public String getRule() {
        return "Whenever a creature you control leaves the battlefield, if it had counters on it, put those counters on {this}.";
    }
}

