/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ThePartingOfTheWaysEffect
extends OneShotEffect {
    ThePartingOfTheWaysEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top five cards of your library. For each nonland card exiled this way, put a number of time counters on that card equal to its mana value. If it doesn't have suspend, it gains suspend";
    }

    private ThePartingOfTheWaysEffect(ThePartingOfTheWaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThePartingOfTheWaysEffect copy() {
        return new ThePartingOfTheWaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game)) {
            SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)card.getManaValue(), (Ability)source, (Game)game);
        }
        return true;
    }
}

