/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheRackEffect
extends OneShotEffect {
    TheRackEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to that player, where X is 3 minus the number of cards in their hand";
    }

    private TheRackEffect(TheRackEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheRackEffect copy() {
        return new TheRackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID playerId = (UUID)game.getState().getValue(source.getSourceId().toString() + "_opponent");
        Player chosenPlayer = game.getPlayer(playerId);
        if (chosenPlayer != null) {
            int damage = 3 - chosenPlayer.getHand().size();
            if (damage > 0) {
                chosenPlayer.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

