/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TheRuinousPowersTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID cardId;

    public TheRuinousPowersTriggeredAbility(UUID cardId) {
        super(null, Duration.EndOfTurn);
        this.cardId = cardId;
    }

    private TheRuinousPowersTriggeredAbility(TheRuinousPowersTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.cardId = ability.cardId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.cardId)) {
            return false;
        }
        if (!event.hasApprovingIdentifier(MageIdentifier.TheRuinousPowersAlternateCast)) {
            return false;
        }
        Card card = game.getCard(this.cardId);
        if (card == null) {
            return false;
        }
        Player owner = game.getPlayer(card.getOwnerId());
        if (owner == null) {
            return false;
        }
        owner.loseLife(card.getManaValue(), game, (Ability)this, false);
        return true;
    }

    public TheRuinousPowersTriggeredAbility copy() {
        return new TheRuinousPowersTriggeredAbility(this);
    }

    public String getRule() {
        return "When you cast a spell this way, its owner loses life equal to its mana value.";
    }
}

