/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheSeaDevilsEffect
extends OneShotEffect {
    TheSeaDevilsEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals that much damage to target creature that player controls";
    }

    private TheSeaDevilsEffect(TheSeaDevilsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheSeaDevilsEffect copy() {
        return new TheSeaDevilsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObjectReference salamanderMOR = (MageObjectReference)this.getValue("sourceMOR");
        if (salamanderMOR == null) {
            return false;
        }
        int amount = SavedDamageValue.MUCH.calculate(game, source, (Effect)this);
        Permanent salamander = salamanderMOR.getPermanentOrLKIBattlefield(game);
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null || salamander == null || target == null) {
            return false;
        }
        target.damage(amount, salamander.getId(), source, game);
        return true;
    }
}

