/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TheSecondDoctorCantAttackEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheSecondDoctorEffect
extends OneShotEffect {
    TheSecondDoctorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may draw a card. Each opponent who does can't attack you or permanents you control during their next turn.";
    }

    private TheSecondDoctorEffect(TheSecondDoctorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheSecondDoctorEffect copy() {
        return new TheSecondDoctorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(Outcome.DrawCard, "Draw a card ?", source, game) || player.drawCards(1, source, game) <= 0 || !game.getOpponents(controller.getId()).contains(playerId)) continue;
            TheSecondDoctorCantAttackEffect effect = new TheSecondDoctorCantAttackEffect(player.getId());
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

