/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheTaleOfTamiyoEffect1
extends OneShotEffect {
    TheTaleOfTamiyoEffect1() {
        super(Outcome.DrawCard);
        this.staticText = "Mill two cards. If two cards that share a card type were milled this way, draw a card and repeat this process.";
    }

    private TheTaleOfTamiyoEffect1(TheTaleOfTamiyoEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public TheTaleOfTamiyoEffect1 copy() {
        return new TheTaleOfTamiyoEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int possibleIterations = controller.getLibrary().size() / 2;
        int iteration = 0;
        do {
            if (++iteration > possibleIterations + 20) {
                game.setDraw(source.getControllerId());
                return true;
            }
            ArrayList cards = new ArrayList(controller.millCards(2, source, game).getCards(game));
            if (cards.size() < 2) break;
            HashSet firstCardTypes = new HashSet(((Card)cards.get(0)).getCardType());
            boolean typesMatch = false;
            for (CardType type : ((Card)cards.get(1)).getCardType()) {
                if (!firstCardTypes.contains(type)) continue;
                typesMatch = true;
                break;
            }
            if (!typesMatch) break;
            controller.drawCards(1, source, game);
        } while (controller.canRespond());
        return true;
    }
}

