/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class TheToymakersTrapEffect
extends OneShotEffect {
    private static final Set<String> options = new HashSet<String>(Arrays.asList("1", "2", "3", "4", "5"));

    TheToymakersTrapEffect() {
        super(Outcome.Benefit);
        this.staticText = "secretly choose a number between 1 and 5 that hasn't been chosen. If you do, an opponent guesses which number you chose, then you reveal the number you chose. If they guessed wrong, they lose life equal to the number they guessed and you draw a card. If they guessed right, sacrifice {this}";
    }

    private TheToymakersTrapEffect(TheToymakersTrapEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheToymakersTrapEffect copy() {
        return new TheToymakersTrapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String number;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List<String> alreadyChosen = TheToymakersTrapEffect.getOrSetValue(game, source);
        HashSet<String> choices = new HashSet<String>(options);
        choices.removeIf(alreadyChosen::contains);
        if (choices.isEmpty()) {
            return false;
        }
        switch (choices.size()) {
            case 0: {
                return false;
            }
            case 1: {
                number = (String)RandomUtil.randomFromCollection(choices);
                break;
            }
            default: {
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Secretly choose a number which hasn't been chosen");
                choice.setChoices(choices);
                controller.choose(this.outcome, (Choice)choice, game);
                number = choice.getChoice();
            }
        }
        game.informPlayers(controller.getLogName() + " has secretly chosen a number");
        TargetOpponent target = new TargetOpponent(true);
        controller.choose(this.outcome, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Guess which number was chosen");
        choice.setChoices(options);
        opponent.choose(this.outcome, (Choice)choice, game);
        String guess = choice.getChoice();
        game.informPlayers(opponent.getLogName() + " has guessed " + guess);
        game.informPlayers("The chosen number was " + number);
        alreadyChosen.add(number);
        alreadyChosen.sort(String::compareTo);
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addInfo("CHOSEN_NUMBERS", CardUtil.addToolTipMarkTags((String)("Chosen numbers: " + alreadyChosen.stream().collect(Collectors.joining(", ")))), game));
        if (!Objects.equals(number, guess)) {
            opponent.loseLife(Integer.parseInt(guess), game, source, false);
            controller.drawCards(1, source, game);
        } else {
            Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.sacrifice(source, game));
        }
        return true;
    }

    private static List<String> getOrSetValue(Game game, Ability source) {
        String key = "chosenNumbers_" + source.getControllerId() + '_' + source.getStackMomentSourceZCC();
        List list = (List)game.getState().getValue(key);
        if (list != null) {
            return list;
        }
        return (List)game.getState().setValue(key, new ArrayList());
    }
}

