/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class TheValeyardChoiceEffect
extends ReplacementEffectImpl {
    TheValeyardChoiceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if an opponent would face a villainous choice, they face that choice an additional time";
    }

    private TheValeyardChoiceEffect(TheValeyardChoiceEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheValeyardChoiceEffect copy() {
        return new TheValeyardChoiceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.FACE_VILLAINOUS_CHOICE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(event.getTargetId()).contains(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

