/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThelonOfHavenwoodBoostEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Fungus creature");

    ThelonOfHavenwoodBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Each Fungus creature gets +1/+1 for each spore counter on it";
    }

    private ThelonOfHavenwoodBoostEffect(ThelonOfHavenwoodBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ThelonOfHavenwoodBoostEffect copy() {
        return new ThelonOfHavenwoodBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            int numCounters = creature.getCounters(game).getCount(CounterType.SPORE);
            if (numCounters <= 0) continue;
            creature.addPower(numCounters);
            creature.addToughness(numCounters);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.FUNGUS.getPredicate());
    }
}

