/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.PermanentToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheoreticalDuplicationTriggeredAbility
extends DelayedTriggeredAbility {
    private static final CreateTokenCopyTargetEffect makeEffect() {
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setUseLKI(true);
        return effect;
    }

    TheoreticalDuplicationTriggeredAbility() {
        super((Effect)TheoreticalDuplicationTriggeredAbility.makeEffect(), Duration.EndOfTurn, false, false);
    }

    private TheoreticalDuplicationTriggeredAbility(TheoreticalDuplicationTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        EntersTheBattlefieldEvent eEvent = (EntersTheBattlefieldEvent)event;
        if (!eEvent.getTarget().isCreature(game) || eEvent.getTarget() instanceof PermanentToken || !game.getOpponents(this.getControllerId()).contains(eEvent.getTarget().getControllerId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(eEvent.getTarget(), game));
        return true;
    }

    public TheoreticalDuplicationTriggeredAbility copy() {
        return new TheoreticalDuplicationTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a nontoken creature enters the battlefield under an opponent's control this turn, create a token that's a copy of that creature.";
    }
}

