/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThiefOfBloodEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("permanent with a counter");

    ThiefOfBloodEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "remove all counters from all permanents. {this} enters with a +1/+1 counter on it for each counter removed this way";
    }

    private ThiefOfBloodEffect(ThiefOfBloodEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThiefOfBloodEffect copy() {
        return new ThiefOfBloodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent;
        int countersRemoved = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
            countersRemoved += permanent.removeAllCounters(source, game);
        }
        if (countersRemoved > 0 && (sourcePermanent = game.getPermanentEntering(source.getSourceId())) != null) {
            sourcePermanent.addCounters(CounterType.P1P1.createInstance(countersRemoved), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

