/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThiefOfSanityEffect
extends OneShotEffect {
    ThiefOfSanityEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top three cards of that player's library, exile one of them face down, then put the rest into their graveyard. You may cast that card for as long as it remains exiled, and mana of any type can be spent to cast it";
    }

    private ThiefOfSanityEffect(ThiefOfSanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThiefOfSanityEffect copy() {
        return new ThiefOfSanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || damagedPlayer == null || sourceObject == null) {
            return false;
        }
        CardsImpl topCards = new CardsImpl();
        topCards.addAllCards((Collection)damagedPlayer.getLibrary().getTopCards(game, 3));
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to exile face down"));
        controller.choose(this.outcome, (Cards)topCards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            controller.moveCards((Cards)topCards, Zone.GRAVEYARD, source, game);
            return true;
        }
        new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(true, CastManaAdjustment.AS_THOUGH_ANY_MANA_TYPE).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        topCards.retainZone(Zone.LIBRARY, game);
        controller.moveCards((Cards)topCards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

