/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class ThievesAuctionEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("nontoken permanents");

    ThievesAuctionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile all nontoken permanents. Starting with you, each player chooses one of the exiled cards and puts it onto the battlefield tapped under their control. Repeat this process until all cards exiled this way have been chosen";
    }

    private ThievesAuctionEffect(ThievesAuctionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThievesAuctionEffect copy() {
        return new ThievesAuctionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl exiledCards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            exiledCards.add((Card)permanent);
            controller.moveCardsToExile((Card)permanent, source, game, true, CardUtil.getCardExileZoneId((Game)game, (UUID)source.getSourceId()), "Thieves' Auction");
        }
        PlayerList playerList = game.getState().getPlayersInRange(controller.getId(), game);
        Player player = playerList.getCurrent(game);
        while (player != null && !exiledCards.isEmpty() && !game.hasEnded()) {
            if (!player.canRespond()) continue;
            TargetCardInExile target = new TargetCardInExile(new FilterCard());
            if (!player.choose(Outcome.PutCardInPlay, (Cards)exiledCards, (TargetCard)target, source, game)) break;
            Card chosenCard = exiledCards.get(target.getFirstTarget(), game);
            if (chosenCard != null) {
                player.moveCards(chosenCard, Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
            exiledCards.remove(chosenCard);
            player = playerList.getNext(game, false);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

