/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThievingSkydiverEffect
extends OneShotEffect {
    ThievingSkydiverEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that artifact is an Equipment, attach it to {this}";
    }

    private ThievingSkydiverEffect(ThievingSkydiverEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThievingSkydiverEffect copy() {
        return new ThievingSkydiverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent artifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || artifact == null || !artifact.hasSubtype(SubType.EQUIPMENT, game)) {
            return false;
        }
        game.processAction();
        permanent.addAttachment(artifact.getId(), source, game);
        return true;
    }
}

