/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThoughtDissectorEffect
extends OneShotEffect {
    private static final GetXValue amount = GetXValue.instance;

    public ThoughtDissectorEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent reveals cards from the top of their library until an artifact card or X cards are revealed, whichever comes first. If an artifact card is revealed this way, put it onto the battlefield under your control and sacrifice {this}. Put the rest of the revealed cards into that player's graveyard.";
    }

    private ThoughtDissectorEffect(ThoughtDissectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtDissectorEffect copy() {
        return new ThoughtDissectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int max = amount.calculate(game, source, (Effect)this);
        if (targetOpponent != null && controller != null && max > 0) {
            int numberOfCard = 0;
            Card artifact = null;
            CardsImpl nonArtifacts = new CardsImpl();
            CardsImpl reveal = new CardsImpl();
            for (Card card : targetOpponent.getLibrary().getCards(game)) {
                reveal.add(card);
                if (card.isArtifact(game)) {
                    artifact = card;
                    break;
                }
                if (++numberOfCard > max) break;
                nonArtifacts.add(card);
            }
            targetOpponent.revealCards(source, (Cards)reveal, game);
            if (artifact != null) {
                game.processAction();
                controller.moveCards(artifact, Zone.BATTLEFIELD, source, game);
                Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
                if (sourcePermanent != null) {
                    sourcePermanent.sacrifice(source, game);
                }
            }
            targetOpponent.moveCards((Cards)nonArtifacts, Zone.GRAVEYARD, source, game);
            return true;
        }
        return false;
    }
}

